% Figure_1_Table_1.m
% 
% Plot value-added shares and trends
% 
% "The Past and Future of U.S. Structural Change" 
% Andrew Foerster, Andreas Hornstein, Pierre-Daniel Sarte, Mark Watson
% September 2025
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % 

% -- Clear Workspace -- %
restoredefaultpath;
clear;
clc;
close all;

% -- File Directories -- % 
datadir = 'Data\DataReplication\DataFinal\'; 
outdir  = 'Tables\';
figdir  = 'Figures\';
matdir  = 'Output\';

% -- Add paths -- %
addpath('Functions\');
addpath('Utilities\')
addpath('Data\')

% -- Load Data and Setup -- %
load_data;
period_lower    = 20;       % Shortest Period 
Share_mat       = sV_mat;
T               = size(Share_mat,1);
nS              = size(Share_mat,2);
SecName_1       = SecName;
i_base          = 5;  % Base sector for logit transformation

% Compute q
q       = floor(2*T/period_lower);
per_q   = 2*T/q;
fprintf('Number of cosine transformations for in-sample period: %d\n',q);
fprintf('Number of Shortest Periods: %5.1f \n',per_q);

% Compute logit transformation
X = logit_s_to_x(Share_mat,i_base);
Y = X(:,1:end ~= i_base);

% Get some results from I_1 model
I_trend     = 1;
Yproj       = LF_Proj(Y,q,I_trend);
Shareproj   = logit_y_to_s(Yproj,i_base);

% -- Figure 1 -- %
i_loc = [3 1 2 4 5];
for i = 1:nS
    fig = figure('Units','Inches','Position',[1 1 2 2]);
    plot(calvec,100*Share_mat(:,i),'- k','LineWidth',1)
    hold on;
      plot(calvec,100*Shareproj(:,i),'- b','LineWidth',2);
    hold off;
    ylim([0.0 25]);
    xlim([1945 2020]);
    %ylabel('Percentage Points');
    %xlabel('Year');
    if i_loc(i) == 5
        ylim([50 75]);
    end
    xlim([1940 2020])
    %title(char(SecName(i)));
    % if i_loc(i) == 1
    %     legend({'Actual','Trend'},'Location','Northeast');
    % end
    % ax = gca;
    % ax.FontSize = ax_fs;
    grid on;
    box on
    print('-depsc',[figdir 'Figure_1_' num2str(i_loc(i))])
end
% Save the figure as a png file
% fname = 'Figure_1';
% figure_to_png(figdir,fname);
% close(fig);  


%% -- Table 1 -- %
foutput = [outdir 'Table_1.csv'];
fid = fopen(foutput, 'w');
fprintf(fid,'Output from For Table 1 \n\n');
fprintf(fid,'Values in Percentage Points \n');
fprintf(fid,',');
i_loc = [2 3 1 4 5];
for i = 1:nS
    j = i_loc(i);
    fprintf(fid,'%s,',char(SecName(j)));
end
fprintf(fid,'\n');
fprintf(fid,'Trend Value in 1947,');
for i = 1:nS
    j = i_loc(i);
    fprintf(fid,'%5.1f,',100*Shareproj(1,j));
end
fprintf(fid,'\n');
fprintf(fid,'Trend Value in 2018,');
for i = 1:nS
    j = i_loc(i);
    fprintf(fid,'%5.1f,',100*Shareproj(end,j));
end
fprintf(fid,'\n');
fprintf(fid,'Change in Trend Value 1947-2018,');
for i = 1:nS
    j = i_loc(i);
    fprintf(fid,'%5.1f,',100*(Shareproj(end,j)-Shareproj(1,j)));
end
fprintf(fid,'\n');
fclose(fid);
